"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "users" ADD "avatarColor" character varying;`.execute(db);
    await (0, kysely_1.sql) `
    UPDATE "users"
    SET "avatarColor" = "user_metadata"."value"->'avatar'->>'color'
    FROM "user_metadata"
    WHERE "users"."id" = "user_metadata"."userId" AND "user_metadata"."key" = 'preferences';`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "users" DROP COLUMN "avatarColor";`.execute(db);
}
//# sourceMappingURL=1745244781846-AddUserAvatarColorColumn.js.map