import { Insertable, Kysely, Updateable } from 'kysely';
import { PluginTriggerType } from 'src/enum';
import { DB } from 'src/schema';
import { WorkflowActionTable, WorkflowFilterTable, WorkflowTable } from 'src/schema/tables/workflow.table';
export declare class WorkflowRepository {
    private db;
    constructor(db: Kysely<DB>);
    getWorkflow(id: string): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    } | undefined>;
    getWorkflowsByOwner(ownerId: string): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    }[]>;
    getWorkflowsByTrigger(type: PluginTriggerType): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    }[]>;
    getWorkflowByOwnerAndTrigger(ownerId: string, type: PluginTriggerType): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    }[]>;
    createWorkflow(workflow: Insertable<WorkflowTable>, filters: Insertable<WorkflowFilterTable>[], actions: Insertable<WorkflowActionTable>[]): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    }>;
    updateWorkflow(id: string, workflow: Updateable<WorkflowTable>, filters: Insertable<WorkflowFilterTable>[] | undefined, actions: Insertable<WorkflowActionTable>[] | undefined): Promise<{
        id: string;
        description: string;
        name: string | null;
        enabled: boolean;
        createdAt: Date;
        ownerId: string;
        triggerType: PluginTriggerType;
    }>;
    deleteWorkflow(id: string): Promise<void>;
    getFilters(workflowId: string): Promise<{
        id: string;
        order: number;
        workflowId: string;
        pluginFilterId: string;
        filterConfig: import("../types/plugin-schema.types").FilterConfig | null;
    }[]>;
    deleteFiltersByWorkflow(workflowId: string): Promise<void>;
    getActions(workflowId: string): Promise<{
        id: string;
        order: number;
        workflowId: string;
        pluginActionId: string;
        actionConfig: import("../types/plugin-schema.types").ActionConfig | null;
    }[]>;
}
