import { Reflector } from '@nestjs/core';
import { MetricOptions } from '@opentelemetry/api';
import { ClassConstructor } from 'class-transformer';
import { MetricService } from 'nestjs-otel';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
type MetricGroupOptions = {
    enabled: boolean;
};
export declare class MetricGroupRepository {
    private metricService;
    private enabled;
    constructor(metricService: MetricService);
    addToCounter(name: string, value: number, options?: MetricOptions): void;
    addToGauge(name: string, value: number, options?: MetricOptions): void;
    addToHistogram(name: string, value: number, options?: MetricOptions): void;
    configure(options: MetricGroupOptions): this;
}
export declare const bootstrapTelemetry: (port: number) => void;
export declare const teardownTelemetry: () => Promise<void>;
export declare class TelemetryRepository {
    private metricService;
    private reflect;
    private configRepository;
    private logger;
    api: MetricGroupRepository;
    host: MetricGroupRepository;
    jobs: MetricGroupRepository;
    repo: MetricGroupRepository;
    constructor(metricService: MetricService, reflect: Reflector, configRepository: ConfigRepository, logger: LoggingRepository);
    setup({ repositories }: {
        repositories: ClassConstructor<unknown>[];
    }): void;
    private wrap;
}
export {};
