"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActivityRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_2 = require("../utils/database");
let ActivityRepository = class ActivityRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    search(options) {
        const { userId, assetId, albumId, isLiked } = options;
        return this.db
            .selectFrom('activity')
            .selectAll('activity')
            .innerJoin('user as user2', (join) => join.onRef('user2.id', '=', 'activity.userId').on('user2.deletedAt', 'is', null))
            .innerJoinLateral((eb) => eb
            .selectFrom((0, kysely_1.sql) `(select 1)`.as('dummy'))
            .select(database_1.columns.userWithPrefix)
            .as('user'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('user').as('user'))
            .leftJoin('asset', 'asset.id', 'activity.assetId')
            .$if(!!userId, (qb) => qb.where('activity.userId', '=', userId))
            .$if(assetId === null, (qb) => qb.where('assetId', 'is', null))
            .$if(!!assetId, (qb) => qb.where('activity.assetId', '=', assetId))
            .$if(!!albumId, (qb) => qb.where('activity.albumId', '=', albumId))
            .$if(isLiked !== undefined, (qb) => qb.where('activity.isLiked', '=', isLiked))
            .where('asset.deletedAt', 'is', null)
            .orderBy('activity.createdAt', 'asc')
            .execute();
    }
    async create(activity) {
        return this.db
            .insertInto('activity')
            .values(activity)
            .returningAll()
            .returning((eb) => (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user').whereRef('user.id', '=', 'activity.userId').select(database_1.columns.user)).as('user'))
            .$narrowType()
            .executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('activity').where('id', '=', (0, database_2.asUuid)(id)).execute();
    }
    async getStatistics({ albumId, assetId, }) {
        const result = await this.db
            .selectFrom('activity')
            .select((eb) => [
            eb.fn.countAll().filterWhere('activity.isLiked', '=', false).as('comments'),
            eb.fn.countAll().filterWhere('activity.isLiked', '=', true).as('likes'),
        ])
            .innerJoin('user', (join) => join.onRef('user.id', '=', 'activity.userId').on('user.deletedAt', 'is', null))
            .leftJoin('asset', 'asset.id', 'activity.assetId')
            .$if(!!assetId, (qb) => qb.where('activity.assetId', '=', assetId))
            .where('activity.albumId', '=', albumId)
            .where(({ or, and, eb }) => or([
            and([eb('asset.deletedAt', 'is', null), eb('asset.visibility', '!=', kysely_1.sql.lit(enum_1.AssetVisibility.Locked))]),
            eb('asset.id', 'is', null),
        ]))
            .executeTakeFirstOrThrow();
        return result;
    }
};
exports.ActivityRepository = ActivityRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ albumId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], ActivityRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ albumId: decorators_1.DummyValue.UUID, userId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ActivityRepository.prototype, "create", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ActivityRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ albumId: decorators_1.DummyValue.UUID, assetId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ActivityRepository.prototype, "getStatistics", null);
exports.ActivityRepository = ActivityRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], ActivityRepository);
//# sourceMappingURL=activity.repository.js.map