import { CanActivate, ExecutionContext } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { Request } from 'express';
import { MaintenanceAuthDto } from 'src/dtos/maintenance.dto';
import { MaintenanceWorkerService } from 'src/maintenance/maintenance-worker.service';
import { LoggingRepository } from 'src/repositories/logging.repository';
export declare const MaintenanceRoute: (options?: {}) => MethodDecorator;
export interface MaintenanceAuthRequest extends Request {
    auth?: MaintenanceAuthDto;
}
export interface MaintenanceAuthenticatedRequest extends Request {
    auth: MaintenanceAuthDto;
}
export declare const MaintenanceAuth: (...dataOrPipes: any[]) => ParameterDecorator;
export declare class MaintenanceAuthGuard implements CanActivate {
    private logger;
    private reflector;
    private service;
    constructor(logger: LoggingRepository, reflector: Reflector, service: MaintenanceWorkerService);
    canActivate(context: ExecutionContext): Promise<boolean>;
}
