"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkResponseDto = exports.SharedLinkPasswordDto = exports.SharedLinkEditDto = exports.SharedLinkCreateDto = exports.SharedLinkSearchDto = void 0;
exports.mapSharedLink = mapSharedLink;
exports.mapSharedLinkWithoutMetadata = mapSharedLinkWithoutMetadata;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const lodash_1 = __importDefault(require("lodash"));
const album_dto_1 = require("./album.dto");
const asset_response_dto_1 = require("./asset-response.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class SharedLinkSearchDto {
    albumId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: false, type: () => String } };
    }
}
exports.SharedLinkSearchDto = SharedLinkSearchDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], SharedLinkSearchDto.prototype, "albumId", void 0);
class SharedLinkCreateDto {
    type;
    assetIds;
    albumId;
    description;
    password;
    slug;
    expiresAt = null;
    allowUpload;
    allowDownload = true;
    showMetadata = true;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("../enum").SharedLinkType }, assetIds: { required: false, type: () => [String] }, albumId: { required: false, type: () => String }, description: { required: false, type: () => String, nullable: true }, password: { required: false, type: () => String, nullable: true }, slug: { required: false, type: () => String, nullable: true }, expiresAt: { required: false, type: () => Date, nullable: true, default: null }, allowUpload: { required: false, type: () => Boolean }, allowDownload: { required: false, type: () => Boolean, default: true }, showMetadata: { required: false, type: () => Boolean, default: true } };
    }
}
exports.SharedLinkCreateDto = SharedLinkCreateDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.SharedLinkType, name: 'SharedLinkType' }),
    __metadata("design:type", String)
], SharedLinkCreateDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true }),
    __metadata("design:type", Array)
], SharedLinkCreateDto.prototype, "assetIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], SharedLinkCreateDto.prototype, "albumId", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkCreateDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkCreateDto.prototype, "password", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkCreateDto.prototype, "slug", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true, nullable: true }),
    __metadata("design:type", Object)
], SharedLinkCreateDto.prototype, "expiresAt", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkCreateDto.prototype, "allowUpload", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkCreateDto.prototype, "allowDownload", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkCreateDto.prototype, "showMetadata", void 0);
class SharedLinkEditDto {
    description;
    password;
    slug;
    expiresAt;
    allowUpload;
    allowDownload;
    showMetadata;
    changeExpiryTime;
    static _OPENAPI_METADATA_FACTORY() {
        return { description: { required: false, type: () => String, nullable: true }, password: { required: false, type: () => String, nullable: true }, slug: { required: false, type: () => String, nullable: true }, expiresAt: { required: false, type: () => Date, nullable: true }, allowUpload: { required: false, type: () => Boolean }, allowDownload: { required: false, type: () => Boolean }, showMetadata: { required: false, type: () => Boolean }, changeExpiryTime: { required: false, type: () => Boolean, description: "Few clients cannot send null to set the expiryTime to never.\nSetting this flag and not sending expiryAt is considered as null instead.\nClients that can send null values can ignore this." } };
    }
}
exports.SharedLinkEditDto = SharedLinkEditDto;
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkEditDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkEditDto.prototype, "password", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", Object)
], SharedLinkEditDto.prototype, "slug", void 0);
__decorate([
    (0, validation_1.Optional)({ nullable: true }),
    __metadata("design:type", Object)
], SharedLinkEditDto.prototype, "expiresAt", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkEditDto.prototype, "allowUpload", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkEditDto.prototype, "allowDownload", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkEditDto.prototype, "showMetadata", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], SharedLinkEditDto.prototype, "changeExpiryTime", void 0);
class SharedLinkPasswordDto {
    password;
    token;
    static _OPENAPI_METADATA_FACTORY() {
        return { password: { required: false, type: () => String }, token: { required: false, type: () => String } };
    }
}
exports.SharedLinkPasswordDto = SharedLinkPasswordDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    (0, swagger_1.ApiProperty)({ example: 'password' }),
    __metadata("design:type", String)
], SharedLinkPasswordDto.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SharedLinkPasswordDto.prototype, "token", void 0);
class SharedLinkResponseDto {
    id;
    description;
    password;
    token;
    userId;
    key;
    type;
    createdAt;
    expiresAt;
    assets;
    album;
    allowUpload;
    allowDownload;
    showMetadata;
    slug;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, description: { required: true, type: () => String, nullable: true }, password: { required: true, type: () => String, nullable: true }, token: { required: false, type: () => String, nullable: true }, userId: { required: true, type: () => String }, key: { required: true, type: () => String }, type: { required: true, enum: require("../enum").SharedLinkType }, createdAt: { required: true, type: () => Date }, expiresAt: { required: true, type: () => Date, nullable: true }, assets: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] }, album: { required: false, type: () => require("./album.dto").AlbumResponseDto }, allowUpload: { required: true, type: () => Boolean }, allowDownload: { required: true, type: () => Boolean }, showMetadata: { required: true, type: () => Boolean }, slug: { required: true, type: () => String, nullable: true } };
    }
}
exports.SharedLinkResponseDto = SharedLinkResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.SharedLinkType, name: 'SharedLinkType' }),
    __metadata("design:type", String)
], SharedLinkResponseDto.prototype, "type", void 0);
function mapSharedLink(sharedLink) {
    const linkAssets = sharedLink.assets || [];
    return {
        id: sharedLink.id,
        description: sharedLink.description,
        password: sharedLink.password,
        userId: sharedLink.userId,
        key: sharedLink.key.toString('base64url'),
        type: sharedLink.type,
        createdAt: sharedLink.createdAt,
        expiresAt: sharedLink.expiresAt,
        assets: linkAssets.map((asset) => (0, asset_response_dto_1.mapAsset)(asset)),
        album: sharedLink.album ? (0, album_dto_1.mapAlbumWithoutAssets)(sharedLink.album) : undefined,
        allowUpload: sharedLink.allowUpload,
        allowDownload: sharedLink.allowDownload,
        showMetadata: sharedLink.showExif,
        slug: sharedLink.slug,
    };
}
function mapSharedLinkWithoutMetadata(sharedLink) {
    const linkAssets = sharedLink.assets || [];
    const albumAssets = (sharedLink?.album?.assets || []).map((asset) => asset);
    const assets = lodash_1.default.uniqBy([...linkAssets, ...albumAssets], (asset) => asset.id);
    return {
        id: sharedLink.id,
        description: sharedLink.description,
        password: sharedLink.password,
        userId: sharedLink.userId,
        key: sharedLink.key.toString('base64url'),
        type: sharedLink.type,
        createdAt: sharedLink.createdAt,
        expiresAt: sharedLink.expiresAt,
        assets: assets.map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { stripMetadata: true })),
        album: sharedLink.album ? (0, album_dto_1.mapAlbumWithoutAssets)(sharedLink.album) : undefined,
        allowUpload: sharedLink.allowUpload,
        allowDownload: sharedLink.allowDownload,
        showMetadata: sharedLink.showExif,
        slug: sharedLink.slug,
    };
}
//# sourceMappingURL=shared-link.dto.js.map