import { BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AssetMetadataKey, AssetVisibility } from 'src/enum';
import { AssetStats } from 'src/repositories/asset.repository';
export declare class DeviceIdDto {
    deviceId: string;
}
export declare class UpdateAssetBase {
    isFavorite?: boolean;
    visibility?: AssetVisibility;
    dateTimeOriginal?: string;
    latitude?: number;
    longitude?: number;
    rating?: number;
    description?: string;
}
export declare class AssetBulkUpdateDto extends UpdateAssetBase {
    ids: string[];
    duplicateId?: string | null;
    dateTimeRelative?: number;
    timeZone?: string;
}
export declare class UpdateAssetDto extends UpdateAssetBase {
    livePhotoVideoId?: string | null;
}
export declare class RandomAssetsDto {
    count?: number;
}
export declare class AssetBulkDeleteDto extends BulkIdsDto {
    force?: boolean;
}
export declare class AssetIdsDto {
    assetIds: string[];
}
export declare enum AssetJobName {
    REFRESH_FACES = "refresh-faces",
    REFRESH_METADATA = "refresh-metadata",
    REGENERATE_THUMBNAIL = "regenerate-thumbnail",
    TRANSCODE_VIDEO = "transcode-video"
}
export declare class AssetJobsDto extends AssetIdsDto {
    name: AssetJobName;
}
export declare class AssetStatsDto {
    visibility?: AssetVisibility;
    isFavorite?: boolean;
    isTrashed?: boolean;
}
export declare class AssetStatsResponseDto {
    images: number;
    videos: number;
    total: number;
}
export declare class AssetMetadataRouteParams {
    id: string;
    key: AssetMetadataKey;
}
export declare class AssetMetadataUpsertDto {
    items: AssetMetadataUpsertItemDto[];
}
export declare class AssetMetadataUpsertItemDto {
    key: AssetMetadataKey;
    value: object;
}
export declare class AssetMetadataMobileAppDto {
    iCloudId?: string;
}
export declare class AssetMetadataResponseDto {
    key: AssetMetadataKey;
    value: object;
    updatedAt: Date;
}
export declare class AssetCopyDto {
    sourceId: string;
    targetId: string;
    sharedLinks?: boolean;
    albums?: boolean;
    sidecar?: boolean;
    stack?: boolean;
    favorite?: boolean;
}
export declare const mapStats: (stats: AssetStats) => AssetStatsResponseDto;
