"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lockableProperties = exports.columns = void 0;
const userColumns = ['id', 'name', 'email', 'avatarColor', 'profileImagePath', 'profileChangedAt'];
const userWithPrefixColumns = [
    'user2.id',
    'user2.name',
    'user2.email',
    'user2.avatarColor',
    'user2.profileImagePath',
    'user2.profileChangedAt',
];
exports.columns = {
    asset: [
        'asset.id',
        'asset.checksum',
        'asset.deviceAssetId',
        'asset.deviceId',
        'asset.fileCreatedAt',
        'asset.fileModifiedAt',
        'asset.isExternal',
        'asset.visibility',
        'asset.libraryId',
        'asset.livePhotoVideoId',
        'asset.localDateTime',
        'asset.originalFileName',
        'asset.originalPath',
        'asset.ownerId',
        'asset.type',
    ],
    assetFiles: ['asset_file.id', 'asset_file.path', 'asset_file.type'],
    authUser: ['user.id', 'user.name', 'user.email', 'user.isAdmin', 'user.quotaUsageInBytes', 'user.quotaSizeInBytes'],
    authApiKey: ['api_key.id', 'api_key.permissions'],
    authSession: ['session.id', 'session.updatedAt', 'session.pinExpiresAt', 'session.appVersion'],
    authSharedLink: [
        'shared_link.id',
        'shared_link.userId',
        'shared_link.expiresAt',
        'shared_link.showExif',
        'shared_link.allowUpload',
        'shared_link.allowDownload',
        'shared_link.password',
    ],
    user: userColumns,
    userWithPrefix: userWithPrefixColumns,
    userAdmin: [
        ...userColumns,
        'createdAt',
        'updatedAt',
        'deletedAt',
        'isAdmin',
        'status',
        'oauthId',
        'profileImagePath',
        'shouldChangePassword',
        'storageLabel',
        'quotaSizeInBytes',
        'quotaUsageInBytes',
    ],
    tag: ['tag.id', 'tag.value', 'tag.createdAt', 'tag.updatedAt', 'tag.color', 'tag.parentId'],
    apiKey: ['id', 'name', 'userId', 'createdAt', 'updatedAt', 'permissions'],
    notification: ['id', 'createdAt', 'level', 'type', 'title', 'description', 'data', 'readAt'],
    syncAsset: [
        'asset.id',
        'asset.ownerId',
        'asset.originalFileName',
        'asset.thumbhash',
        'asset.checksum',
        'asset.fileCreatedAt',
        'asset.fileModifiedAt',
        'asset.localDateTime',
        'asset.type',
        'asset.deletedAt',
        'asset.isFavorite',
        'asset.visibility',
        'asset.duration',
        'asset.livePhotoVideoId',
        'asset.stackId',
        'asset.libraryId',
    ],
    syncAlbumUser: ['album_user.albumId as albumId', 'album_user.userId as userId', 'album_user.role'],
    syncStack: ['stack.id', 'stack.createdAt', 'stack.updatedAt', 'stack.primaryAssetId', 'stack.ownerId'],
    syncUser: ['id', 'name', 'email', 'avatarColor', 'deletedAt', 'updateId', 'profileImagePath', 'profileChangedAt'],
    stack: ['stack.id', 'stack.primaryAssetId', 'ownerId'],
    syncAssetExif: [
        'asset_exif.assetId',
        'asset_exif.description',
        'asset_exif.exifImageWidth',
        'asset_exif.exifImageHeight',
        'asset_exif.fileSizeInByte',
        'asset_exif.orientation',
        'asset_exif.dateTimeOriginal',
        'asset_exif.modifyDate',
        'asset_exif.timeZone',
        'asset_exif.latitude',
        'asset_exif.longitude',
        'asset_exif.projectionType',
        'asset_exif.city',
        'asset_exif.state',
        'asset_exif.country',
        'asset_exif.make',
        'asset_exif.model',
        'asset_exif.lensModel',
        'asset_exif.fNumber',
        'asset_exif.focalLength',
        'asset_exif.iso',
        'asset_exif.exposureTime',
        'asset_exif.profileDescription',
        'asset_exif.rating',
        'asset_exif.fps',
    ],
    exif: [
        'asset_exif.assetId',
        'asset_exif.autoStackId',
        'asset_exif.bitsPerSample',
        'asset_exif.city',
        'asset_exif.colorspace',
        'asset_exif.country',
        'asset_exif.dateTimeOriginal',
        'asset_exif.description',
        'asset_exif.exifImageHeight',
        'asset_exif.exifImageWidth',
        'asset_exif.exposureTime',
        'asset_exif.fileSizeInByte',
        'asset_exif.fNumber',
        'asset_exif.focalLength',
        'asset_exif.fps',
        'asset_exif.iso',
        'asset_exif.latitude',
        'asset_exif.lensModel',
        'asset_exif.livePhotoCID',
        'asset_exif.longitude',
        'asset_exif.make',
        'asset_exif.model',
        'asset_exif.modifyDate',
        'asset_exif.orientation',
        'asset_exif.profileDescription',
        'asset_exif.projectionType',
        'asset_exif.rating',
        'asset_exif.state',
        'asset_exif.timeZone',
    ],
    plugin: [
        'plugin.id as id',
        'plugin.name as name',
        'plugin.title as title',
        'plugin.description as description',
        'plugin.author as author',
        'plugin.version as version',
        'plugin.wasmPath as wasmPath',
        'plugin.createdAt as createdAt',
        'plugin.updatedAt as updatedAt',
    ],
};
exports.lockableProperties = [
    'description',
    'dateTimeOriginal',
    'latitude',
    'longitude',
    'rating',
    'timeZone',
];
//# sourceMappingURL=database.js.map