import { AddUsersDto, AlbumInfoDto, AlbumResponseDto, AlbumsAddAssetsDto, AlbumsAddAssetsResponseDto, AlbumStatisticsResponseDto, CreateAlbumDto, GetAlbumsDto, UpdateAlbumDto, UpdateAlbumUserDto } from 'src/dtos/album.dto';
import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AlbumService } from 'src/services/album.service';
import { UUIDParamDto } from 'src/validation';
export declare class AlbumController {
    private service;
    constructor(service: AlbumService);
    getAllAlbums(auth: AuthDto, query: GetAlbumsDto): Promise<AlbumResponseDto[]>;
    createAlbum(auth: AuthDto, dto: CreateAlbumDto): Promise<AlbumResponseDto>;
    getAlbumStatistics(auth: AuthDto): Promise<AlbumStatisticsResponseDto>;
    getAlbumInfo(auth: AuthDto, { id }: UUIDParamDto, dto: AlbumInfoDto): Promise<AlbumResponseDto>;
    updateAlbumInfo(auth: AuthDto, { id }: UUIDParamDto, dto: UpdateAlbumDto): Promise<AlbumResponseDto>;
    deleteAlbum(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    addAssetsToAlbum(auth: AuthDto, { id }: UUIDParamDto, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    addAssetsToAlbums(auth: AuthDto, dto: AlbumsAddAssetsDto): Promise<AlbumsAddAssetsResponseDto>;
    removeAssetFromAlbum(auth: AuthDto, dto: BulkIdsDto, { id }: UUIDParamDto): Promise<BulkIdResponseDto[]>;
    addUsersToAlbum(auth: AuthDto, { id }: UUIDParamDto, dto: AddUsersDto): Promise<AlbumResponseDto>;
    updateAlbumUser(auth: AuthDto, { id }: UUIDParamDto, userId: string, dto: UpdateAlbumUserDto): Promise<void>;
    removeUserFromAlbum(auth: AuthDto, { id }: UUIDParamDto, userId: string): Promise<void>;
}
