import { AudioCodec, Colorspace, CQMode, LogLevel, OAuthTokenEndpointAuthMethod, ToneMapping, TranscodeHardwareAcceleration, TranscodePolicy, VideoCodec, VideoContainer } from 'src/enum';
import { ConcurrentQueueName, FullsizeImageOptions, ImageOptions } from 'src/types';
export interface SystemConfig {
    backup: {
        database: {
            enabled: boolean;
            cronExpression: string;
            keepLastAmount: number;
        };
    };
    ffmpeg: {
        crf: number;
        threads: number;
        preset: string;
        targetVideoCodec: VideoCodec;
        acceptedVideoCodecs: VideoCodec[];
        targetAudioCodec: AudioCodec;
        acceptedAudioCodecs: AudioCodec[];
        acceptedContainers: VideoContainer[];
        targetResolution: string;
        maxBitrate: string;
        bframes: number;
        refs: number;
        gopSize: number;
        temporalAQ: boolean;
        cqMode: CQMode;
        twoPass: boolean;
        preferredHwDevice: string;
        transcode: TranscodePolicy;
        accel: TranscodeHardwareAcceleration;
        accelDecode: boolean;
        tonemap: ToneMapping;
    };
    job: Record<ConcurrentQueueName, {
        concurrency: number;
    }>;
    logging: {
        enabled: boolean;
        level: LogLevel;
    };
    machineLearning: {
        enabled: boolean;
        urls: string[];
        availabilityChecks: {
            enabled: boolean;
            timeout: number;
            interval: number;
        };
        clip: {
            enabled: boolean;
            modelName: string;
        };
        duplicateDetection: {
            enabled: boolean;
            maxDistance: number;
        };
        facialRecognition: {
            enabled: boolean;
            modelName: string;
            minScore: number;
            minFaces: number;
            maxDistance: number;
        };
        ocr: {
            enabled: boolean;
            modelName: string;
            minDetectionScore: number;
            minRecognitionScore: number;
            maxResolution: number;
        };
    };
    map: {
        enabled: boolean;
        lightStyle: string;
        darkStyle: string;
    };
    reverseGeocoding: {
        enabled: boolean;
    };
    metadata: {
        faces: {
            import: boolean;
        };
    };
    oauth: {
        autoLaunch: boolean;
        autoRegister: boolean;
        buttonText: string;
        clientId: string;
        clientSecret: string;
        defaultStorageQuota: number | null;
        enabled: boolean;
        issuerUrl: string;
        mobileOverrideEnabled: boolean;
        mobileRedirectUri: string;
        scope: string;
        signingAlgorithm: string;
        profileSigningAlgorithm: string;
        tokenEndpointAuthMethod: OAuthTokenEndpointAuthMethod;
        timeout: number;
        storageLabelClaim: string;
        storageQuotaClaim: string;
        roleClaim: string;
    };
    passwordLogin: {
        enabled: boolean;
    };
    storageTemplate: {
        enabled: boolean;
        hashVerificationEnabled: boolean;
        template: string;
    };
    image: {
        thumbnail: ImageOptions;
        preview: ImageOptions;
        colorspace: Colorspace;
        extractEmbedded: boolean;
        fullsize: FullsizeImageOptions;
    };
    newVersionCheck: {
        enabled: boolean;
    };
    nightlyTasks: {
        startTime: string;
        databaseCleanup: boolean;
        missingThumbnails: boolean;
        clusterNewFaces: boolean;
        generateMemories: boolean;
        syncQuotaUsage: boolean;
    };
    trash: {
        enabled: boolean;
        days: number;
    };
    theme: {
        customCss: string;
    };
    library: {
        scan: {
            enabled: boolean;
            cronExpression: string;
        };
        watch: {
            enabled: boolean;
        };
    };
    notifications: {
        smtp: {
            enabled: boolean;
            from: string;
            replyTo: string;
            transport: {
                ignoreCert: boolean;
                host: string;
                port: number;
                secure: boolean;
                username: string;
                password: string;
            };
        };
    };
    templates: {
        email: {
            welcomeTemplate: string;
            albumInviteTemplate: string;
            albumUpdateTemplate: string;
        };
    };
    server: {
        externalDomain: string;
        loginPageMessage: string;
        publicUsers: boolean;
    };
    user: {
        deleteDelay: number;
    };
}
export type MachineLearningConfig = SystemConfig['machineLearning'];
export declare const defaults: Readonly<SystemConfig>;
