"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptPasswordQuestions = exports.ResetAdminPasswordCommand = void 0;
const nest_commander_1 = require("nest-commander");
const cli_service_1 = require("../services/cli.service");
const prompt = (inquirer) => {
    return function ask(admin) {
        const { id, oauthId, email, name } = admin;
        console.log(`Found Admin:
- ID=${id}
- OAuth ID=${oauthId}
- Email=${email}
- Name=${name}`);
        return inquirer.ask('prompt-password', {}).then(({ password }) => password);
    };
};
let ResetAdminPasswordCommand = class ResetAdminPasswordCommand extends nest_commander_1.CommandRunner {
    service;
    inquirer;
    constructor(service, inquirer) {
        super();
        this.service = service;
        this.inquirer = inquirer;
    }
    async run() {
        try {
            const { password, provided } = await this.service.resetAdminPassword(prompt(this.inquirer));
            if (provided) {
                console.log(`The admin password has been updated.`);
            }
            else {
                console.log(`The admin password has been updated to:\n${password}`);
            }
        }
        catch (error) {
            console.error(error);
            console.error('Unable to reset admin password');
        }
    }
};
exports.ResetAdminPasswordCommand = ResetAdminPasswordCommand;
exports.ResetAdminPasswordCommand = ResetAdminPasswordCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'reset-admin-password',
        description: 'Reset the admin password',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService,
        nest_commander_1.InquirerService])
], ResetAdminPasswordCommand);
let PromptPasswordQuestions = class PromptPasswordQuestions {
    parsePassword(value) {
        return value;
    }
};
exports.PromptPasswordQuestions = PromptPasswordQuestions;
__decorate([
    (0, nest_commander_1.Question)({
        message: 'Please choose a new password (optional)',
        name: 'password',
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PromptPasswordQuestions.prototype, "parsePassword", null);
exports.PromptPasswordQuestions = PromptPasswordQuestions = __decorate([
    (0, nest_commander_1.QuestionSet)({ name: 'prompt-password' })
], PromptPasswordQuestions);
//# sourceMappingURL=reset-admin-password.command.js.map